﻿var imageHeatMapDashboardResults = {
    mainSection: null,
    questionNavigator: null,
    questionNavigatorTable: null,
    language: 'en',
    surveyLanguage: 'en'
}

var selectedQuestionRow = null;
$(document).ready(function () {
    dashboardLoadResultsConfiguration();
    $("#onDemandUpdate").hide();
    if (imageHeatMapDashboardResults.mainSection.length > 0) {
        imageHeatMapDashboardBindQuestion();
        getQuestionsProgress();
    }
});

$('.dashboard-activate-survey').click(function () {
    var parameters = {
        surveyId: a4.getSurveyId()
    };
    var hasActivated = a4.getAction("StartAndDeploySurvey", "Shared", 'Survey');
    a4.callServerMethod(hasActivated, parameters, function (result) {
        if (result['success']) {
            window.location.reload();
        }
    });
});

$(".h-exportpdf").on("click", function () {
    var dialogContent = { Title: createDashboardResources.ExportPDFHeader, Message: createDashboardResources.ExportHeatMapPdfDescription, ConfirmButton: createDashboardResources.Confirm };
    modalDialog.showConfirmDialog(dialogContent, function () { exportCharts(); });
});

function exportCharts() {
    showLoader(`${createDashboardResources.ExportImageLoadText} PDF`);

    var doc;
    html2canvas(document.querySelector("#heatmapDashboard"), { useCORS: true }).then(canvas => {
        var filename = `${createDashboardResources.Charts}.pdf`;
        var canvasWidth;
        var canvasHeight;
        var img = canvas.toDataURL("image/png", canvasWidth = canvas.width * 0.8, canvasHeight = canvas.height * 0.8);

        var ratio = canvasHeight / canvasWidth;

        doc = new jsPDF('p', 'pt', "a4");
        var width = doc.internal.pageSize.getWidth();
        var height = width * ratio;
        doc.addImage(img, 'JPEG', 0, 0, width, height);
        doc.save(filename);

        hideLoader();
    });
}

function dashboardLoadResultsConfiguration() {
    imageHeatMapDashboardResults.mainSection = $(".image-heatmap-resultsDashboard");
    var configurationSection = $(".v-configurationDashboard", imageHeatMapDashboardResults.mainSection);
    var userLanguage = $("#userLanguage", configurationSection).val();
    if(userLanguage != undefined && userLanguage != "") {
        imageHeatMapDashboardResults.language = userLanguage;
    }
}

function loadLastSelectedQuestionFromConfig(attemptNum) {
    var qnsTableCheckInterval;
    if (selectedVariableId > 0 || imgHeatMapQuestionConfig) {
        var variableIdOfQuestionTobeLoaded = selectedVariableId > 0 ? selectedVariableId : imgHeatMapQuestionConfig.VariableId;
        qnsTableCheckInterval = setInterval(function () {
            if ($('tbody>tr', '.h-questionNavigatorDashboard-table').length > 0) {
                clearInterval(qnsTableCheckInterval);
                loadLastSelectedQuestion(variableIdOfQuestionTobeLoaded, attemptNum);
            }
        }, 1000);
    }
}

function loadLastSelectedQuestion(variableIdOfQuestionTobeLoaded, attemptNum) {
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var selectedQuestion = null;
    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("variableId") === variableIdOfQuestionTobeLoaded) {
            selectedQuestion = currentQn;
            return true;
        }
        return false;
    });
    
    if (selectedQuestion) {
        questionClickEventHandler(selectedQuestion, false);
        selectedQuestion.get(0).scrollIntoView();
    }
    else if (attemptNum <= 3) {
        loadLastSelectedQuestionFromConfig(attemptNum + 1);
    }
}

function imageHeatMapDashboardBindQuestion() {
    imageHeatMapDashboardResults.questionNavigator = $(".h-questionNavigatorDashboard");
    imageHeatMapDashboardResults.questionNavigatorTable = $(".h-questionNavigatorDashboard-table", imageHeatMapDashboardResults.questionNavigator).a4datatable({
        ajaxAction: a4.getSurveyAction("GetQuestionsForImageHeatMap", "ImageHeatMap"),
        ajaxParams: { "language": imageHeatMapDashboardResults.language  },

        columns: [
            {
                "Name": "QuestionDefinition",
                "Title": "",
                "Data": function (source, type, val) {
                    var statusIcon = $("<div>").addClass("dashboard-status-icon");
                    if (source['HasDashboard'] && source['DashboardStatus'] == 'Completed') {
                        $(statusIcon).append($("<i>")).addClass("fa fa-pie-chart");
                        $(statusIcon).append($("<i>")).find("span").remove();
                    } else if (source['DashboardStatus'] == 'Error') {
                        $(statusIcon).append($("<i>")).addClass("fa fa-exclamation");
                    }

                    var jqhtml = $("<div>")
                        .append($("<div>").addClass("question h-goToQuestionDashboard")
                            .attr("title", source.Text)
                            .append($(statusIcon))
                            .append($("<div>").addClass("question-labels-container")
                                .append($("<div>").addClass("name").append(source.Name))
                                .append($("<div>").addClass("text").append(source.Text))));
                    return jqhtml.html();
                }
            }
        ],

        allowRowSelection: false,
        displayColumnSelector: false,

        rowCreated: function (event, d) {
            var currentRow = $(d.row);
            currentRow.data("id", d.data.Id);
            currentRow.data("sourceKey", d.data.SourceKey);
            currentRow.data("variableId", d.data.Variables[0] ? d.data.Variables[0].SourceKey : 0);
            currentRow.data("variableName", d.data.Variables[0] ? d.data.Variables[0].Name : 0);
            currentRow.data("hasDashboard", d.data.HasDashboard);
            currentRow.data("dashboardStatus", d.data.DashboardStatus);
            currentRow.data("description", d.data.Text);
            currentRow.data("dashboardLastUpdateDateTime", d.data.DashboardLastUpdateDateTime);
            currentRow.data("name", d.data.Name);
            currentRow.data("type", d.data.Type);
            currentRow.data("surveyLanguage", d.data.SurveyLanguage);
        },
        customCallback: function () { loadLastSelectedQuestionFromConfig(1); }
    });

    $(".h-refreshButton", imageHeatMapDashboardResults.questionNavigatorTable).click(function () {
        showInitialInstructions();
    });

    $("input[type=search]", imageHeatMapDashboardResults.questionNavigatorTable).keyup(function (event) {
        var searchText = $("input[type=search]").val();
        // Here key code 13 means, press enter key event
        if (event.which === 13 && searchText.length == 0) {
            setTimeout(addBackgroundColor, 95);
        }
    });

    function addBackgroundColor() {
        $('#DataTables_Table_0 tr td').each(function () {
            $(this).parents("tr").addClass("selected");
        });
    }

    $(imageHeatMapDashboardResults.questionNavigator).on("click", ".h-goToQuestionDashboard", function (e) {
        var row = $(this).parents("tr");
        var dashboardStatus = row.data("dashboardStatus");
        $("#onDemandUpdate").hide();
        if (dashboardStatus === 'InProgress') {
            a4.showErrorMessage(createDashboardResources.DashboardRunningStatus);
        } else if (dashboardStatus === 'Error') {
            questionClickEventHandler(row, false);
        } else if (dashboardStatus === 'Completed') {
            setCurrentRowSelected(row);
            loadWidgetsForSelectedQuestion(row, true);
        }
        else {
            questionClickEventHandler(row, true);
        }
    });
}

var interval;
function getQuestionsProgress() {
    interval = setInterval(loadQuestionsToDisplay, 10000);
}

function questionClickEventHandler(row, updateConfig) {
    $(".filterIconDiv").removeClass("hideFilterIcon");
    changeRowQuestionDisplay(row, updateConfig);
}

function loadQuestionsToDisplay() {
    a4.callServerMethod(a4.getSurveyAction("GetQuestionsStatus", "ImageHeatMap"), {
    }, function (response) {
        if (response && response.length != 0) {
            $('#DataTables_Table_0 tr td').each(function () {
                var row = $(this).parents("tr");
                var dashboardStatus = row.data("dashboardStatus");
                if (dashboardStatus === 'InProgress' || dashboardStatus === 'UpdateInProgress') {
                    let questions = response.filter(b => b['VariableId'] === row.data("variableId"))
                    if (questions && questions.length > 0) {
                        row.data("dashboardStatus", questions[0]['DashboardStatus']);
                        if (questions[0]['DashboardStatus'] === 'Completed') {
                            if (row.data("hasDashboard") == true) {
                                a4.showSuccessMessage(createDashboardResources.DashboardCreated);
                            }
                            removeSpinIcon(row);
                            $(".dashboard-status-icon", row).addClass("fa fa-pie-chart");
                            $(".dashboard-status-icon", row).find("span").remove();

                            row.data("hasDashboard", true);
                            if (selectedVariableId === questions[0]['VariableId']) {
                                loadWidgetsForSelectedQuestion(row, true);
                            }
                        }
                        else if (questions[0]['DashboardStatus'] === 'Error') {
                            removeSpinIcon(row);
                            $(".dashboard-status-icon", row).addClass("fa fa-exclamation");
                        }
                    }
                }
            });
        }

    })
}

var selectedVariableId;
var selectedQuestionId;
var selectedQuestionName;
function changeRowQuestionDisplay(row, updateConfig) {
    selectedQuestionRow = row;
    selectedVariableId = row.data("variableId");
    selectedQuestionId = row.data("sourceKey");
    let hasDashboard = row.data("hasDashboard");
    selectedQuestionName = row.data("variableName");
    imageHeatMapDashboardResults.surveyLanguage = row.data("surveyLanguage");

    if (!hasDashboard) {
        var confirmationResources = modalDialog.createDialogResources(createDashboardResources.CreateDashboardDescription, createDashboardResources.CreateDashboardTitle);
        modalDialog.showConfirmDialog(confirmationResources, function () {
            a4.callServerMethod(a4.getSurveyAction("CheckForLicensesAndResponses", "ImageHeatMap"), {
                questionName: selectedQuestionName
            }, function (response) {
                let hasResponses = response['hasResponses'];
                let hasLicenses = response['hasValidLicenses'];

                if (hasResponses == 0) {
                    setCurrentRowSelected(row);
                    row.toggleClass("selected");
                    disableDashboardIcon(row);
                    a4.showErrorMessage(dashboardErrorMessages.QuestionHasNoResponses);
                    showInitialInstructions();
                } else if (!hasLicenses) {
                    setCurrentRowSelected(row);
                    row.toggleClass("selected");
                    disableDashboardIcon(row);
                    a4.showErrorMessage(dashboardErrorMessages.NoLicensesForDashboardCreation);
                    showInitialInstructions();
                }
                else {
                    handleLicensingAndLoadDashboard(row);
                }
            });
        });
    }
    else {
        a4.callServerMethod(a4.getSurveyAction("CheckForNewUpdatesOrResponses", "ImageHeatMap"), {
            questionName: row.data("variableName")
        }, function (response) {
            let hasResponses = response['hasResponses'];
            if (hasResponses == 0) {
                setCurrentRowSelected(row);
                row.toggleClass("selected");
                disableDashboardIcon(row);
                a4.showErrorMessage(dashboardErrorMessages.QuestionHasNoResponses);
                showInitialInstructions();
            } else {
                loadWidgetsForSelectedQuestion(row, updateConfig);
            }
        });
    }
}

function handleLicensingAndLoadDashboard(row) {
    a4.callServerMethod(a4.getSurveyAction("PerformLicensesDeductionAndAssociatedActivities", "ImageHeatMap"), {
        questionId: selectedQuestionId, variableId: row.data("variableId"), questionName: row.data("variableName")
    }, function (response) {
        let status = response['success'];

        if (status) {
            createHeatMapImage(row);
        }
    });
}

function createHeatMapImage(row) {
    showLoader(createDashboardResources.CreateDashboard);
    a4.callServerMethod(a4.getSurveyAction("CreateHeatMapImage", "ImageHeatMap"), {
        questionId: selectedQuestionId, questionName: row.data("variableName"), variableId: row.data("variableId"), language: imageHeatMapDashboardResults.surveyLanguage
    }, function (response) {
        hideLoader();
        if (response['success']) {
            row.data("dashboardStatus", response['status']);
            row.data("hasDashboard", true);
            enableDashboardProgressIcon(row);
            setDashboardInfo(row.data("name"), row.data("dashboardLastUpdateDateTime"));
        }
        setCurrentRowSelected(row);
    });
}

function loadWidgetsForSelectedQuestion(row, updateConfig) {
    a4.hideErrorMessage();
    showLoader(createDashboardResources.LoadDashboard);
    selectedQuestionId = row.data("sourceKey");
    selectedVariableId = row.data("variableId");
    selectedQuestionName = row.data("variableName");
    selectedQuestionRow = row;
    $(".originalImage").attr("src", '');
    imageHeatMapDashboardResults.surveyLanguage = row.data("surveyLanguage");
    
    a4.callServerMethod(a4.getSurveyAction("GetDataForImageHeatMapDashboardWidgets", "ImageHeatMap"), {
        questionId: selectedQuestionId, questionName: row.data("variableName"), variableId: selectedVariableId, language: imageHeatMapDashboardResults.surveyLanguage, updateConfig: updateConfig
    }, function (response) {
        let responsesCount = response['responseCount'];
        let dataObject = response['heatMapDataObject'];
        if (responsesCount > 0) {
            $("#onDemandUpdate").show();

            let imageURL = dataObject.ImageURL;
            $(".originalImage").attr("src", imageURL);
            var img = document.getElementById('originalImage');

            //or however you get a handle to the IMG
            var width = img.clientWidth;
            let heatMapBase64 = dataObject.HeatMapBase64Data;
            $(".heatMapImage").attr("src", "data:image/png;base64," + heatMapBase64).css({ 'style': 'width:' + width + 'px' });

            setDashboardInfo(row.data("name"), response['dashboardLastUpdateDateTime']);
            row.data("hasDashboard", true);
            enableDashboardIcon(row);
            checkForUpdatesAvailability();
            hideInitialInstructions();
            hideLoader();
            setCurrentRowSelected(row);
        } else {
            row.data("hasDashboard", false);
            disableDashboardIcon(row);
            setCurrentRowSelected(row);
            row.toggleClass("selected");
            hideLoader();
            a4.showErrorMessage(dashboardErrorMessages.QuestionHasNoResponses);
            showInitialInstructions();
        }
    });
}

function checkForUpdatesAvailability() {
    a4.callServerMethod(a4.getSurveyAction("CheckForNewUpdatesOrResponses", "ImageHeatMap"), {
        questionName: selectedQuestionName
    }, function (response) {
        let onDemandElement = $("#onDemandButton");
        if (response['hasNewUpdatesOrResponses'] && onDemandElement !== undefined && onDemandElement.length > 0) {
            $("#onDemandButton").removeClass("disabled");
            a4.showSuccessMessage(createDashboardResources.DashboardUpdateAvailable, 3000);
        }
        else if (onDemandElement !== undefined && onDemandElement.length > 0) {
            $("#onDemandButton").addClass("disabled");
        }
    });
}

function runOnDemandUpdate(ev) {
    var confirmationResources = modalDialog.createDialogResources(createDashboardResources.UpdateDashboardDescription, createDashboardResources.UpdateDashboardTitle);
    modalDialog.showConfirmDialog(confirmationResources, function () {
        a4.callServerMethod(a4.getSurveyAction("RunOnDemandUpdate", "ImageHeatMap"), {
            variableId: selectedVariableId, questionId: selectedQuestionId, questionName: selectedQuestionName, language: imageHeatMapDashboardResults.surveyLanguage
        }, function (response) {
            let hasInValidLicenses = response.hasOwnProperty("hasValidLicenses") && response.hasValidLicenses === false;
            let isSuccess = response.hasOwnProperty("success") && response.success === true;

            if (hasInValidLicenses) {
                a4.showErrorMessage(dashboardErrorMessages.NoLicensesForDashboardUpdate);
            }
            else if (isSuccess) {
                showLoader(createDashboardResources.UpdateDashboard);
                loadWidgetsForSelectedQuestion(selectedQuestionRow, false);
                a4.showSuccessMessage(createDashboardResources.DashboardSuccess);
            }
        });
    });
}

function setCurrentRowSelected(row) {
    var selectedElements = $(".selected", imageHeatMapDashboardResults.questionNavigatorTable);
    if (selectedElements && selectedElements.length > 0) {
        selectedElements[0].className = selectedElements[0].classList[0];
    }
    row.toggleClass("selected");
}

function setDashboardInfo(questionName, updatedDate) {
    $(".dashboard-name").text(questionName);
    updatedDate = updatedDate === null ? "" : updatedDate;
    $(".dashboard-updated-date .updated-date").text(updatedDate);
}

function hideInitialInstructions() {
    $(".image-heatmap-dashboard-container").show();
    $("#image-heatmap-initialInstructions").hide();
}

function showInitialInstructions() {
    $(".image-heatmap-dashboard-container").hide();
    $("#image-heatmap-initialInstructions").show();
}

function enableDashboardIcon(row) {
    let statusIcon = $('.dashboard-status-icon', $(row));
    $(statusIcon).append($("<i>")).addClass("fa fa-pie-chart");
    $(statusIcon).append($("<i>")).find("span").remove();
}

function enableDashboardProgressIcon(row) {
    $(".dashboard-status-icon", row).addClass("loading-icon").addClass("loading-icon").append($("<span class='fa fa-circle-o-notch fa-spin fa-fw'></span>"));
}

function removeSpinIcon(row) {
    let statusIcon = $('.dashboard-status-icon', $(row));
    $(statusIcon).removeClass('loading-icon');
    $(statusIcon).append($("<i>")).find("span").remove();
}

function disableDashboardIcon(row) {
    let statusIcon = $('.dashboard-status-icon', $(row));
    $(statusIcon).append($("<i>")).removeClass("fa fa-pie-chart");
    $(statusIcon).append($("<i>")).find("span").remove();
}

function showLoader(loadingText) {
    var loader = $("#loaderIcon");
    if (loadingText && loadingText != "") {
        $(".loading-text-content #loadingStatus", loader).text(loadingText);
    }
    loader.removeClass("hide");
}

function hideLoader() {
    $("#loaderIcon").addClass("hide");
}